/* run length encoding of apple screens                  */
/* uses an interleafed technique and pcx format encoding */

#include <stdio.h>
#include <fcntl.h>
#include <dos.h>
#include <bios.h>
#include <io.h>
#include <string.h>
#include <malloc.h>

FILE *bcxfile;

int bot2bcx(char *name1, char *name2)
{
    char far *bigbuffer;

    unsigned char scratchbuf[40];
    unsigned char evenbuf[20];
    unsigned char oddbuf[20];
    unsigned int  offset=0;
    int packet =   40;
    int halfpack = 20;
    int i,interleaf;

    int fh;

    if((fh = open(name1,O_RDONLY|O_BINARY)) == -1)return -1;

    bigbuffer= _fmalloc(7680);
    read(fh,bigbuffer,7680);
    close(fh);
    bcxfile=fopen(name2,"wb");

    /* width in bytes x height in rasters */
    fputc((char)packet,bcxfile);/* write the header */
    fputc((char)192,bcxfile);

          for(offset=0;offset<7680;offset+=packet){
                memcpy(scratchbuf,bigbuffer+offset,packet);
                interleaf=0;
                i=0;
                while(i<packet)
                {
                  evenbuf[interleaf]=scratchbuf[i];
                  i++;
                  oddbuf[interleaf]=scratchbuf[i];
                  i++;
                  interleaf++;
                  }
                encline(evenbuf,halfpack);
                encline(oddbuf,halfpack);
            }
            fclose(bcxfile);

}

main(int argc,char *argv[])
{
   char buffer[128];
   char  name1[128];
   char  name2[128];
   char *wordptr;

          switch(argc)
          {
            case 2: strcpy(buffer,argv[1]);
                    wordptr=strtok(buffer,".");
                    strcpy(name1,buffer);
                    strcat(name1,".BOT");
                    strcpy(name2,buffer);
                    strcat(name2,".BCX");
                    bot2bcx(name1,name2);

 default: break;
          }
          exit(0);
}



encline(inbuff,inlen)  /* encodes a raw line and writes it out to disk */
unsigned char *inbuff;
int inlen;
{
    unsigned char this,last;
    int srcindex,i;
    register int total;
    register unsigned char runcount;
    total=0;
    last = *(inbuff); runcount=1;

for(srcindex=1;srcindex!=inlen;srcindex++){
    this= *(++inbuff);
    if(this==last){
        runcount++;
        if(runcount==63){
            if(!(i=encput(last,runcount)))
            return(0);
            total+=i;
            runcount=0;
        }
    }
    else{
        if(runcount){
            if(!(i=encput(last,runcount)))
            return(0);
            total+=i;
        }
        last=this;
        runcount=1;
      }
   }

if(runcount){
    if(!(i=encput(last,runcount)))
    return(0);
    return(total+i);
    }
    return (total);

}


encput(byt,cnt)       /* the writer for the encline function */
unsigned char byt,cnt;
{
          if(cnt){
            if((cnt==1)&& (0xc0 != (0xc0 &byt))){
                if(EOF == fputc((int)byt,bcxfile))
                return(0);
                return(1);
            }
            else{
                if(EOF==fputc((int)0xc0|cnt,bcxfile))
                return(0);
                if(EOF==fputc((int)byt,bcxfile))
                return(0);
                return(2);
            }
        }
        return(0);

}


